//===============================================================================
// Microsoft patterns & practices Enterprise Library
// Configuration Application Block
//===============================================================================
// Copyright  Microsoft Corporation.  All rights reserved.
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY
// OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT
// LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE.
//===============================================================================

using System;

namespace Microsoft.Practices.EnterpriseLibrary.Configuration.Injection
{
	/// <summary>
	/// Represents a factory for creating objects described by <see cref="NameTypeConfigurationElement"/> objects.
	/// </summary>
	/// <typeparam name="TObjectToCreate">The type of object to create.</typeparam>
	/// <typeparam name="TObjectConfiguration">The configuraiton object for the object to create. This object must be derived from <see cref="NameTypeConfigurationElement"/>.</typeparam>
	public class NameTypeInjectionFactory<TObjectToCreate, TObjectConfiguration> : InjectionFactory<TObjectToCreate, TObjectConfiguration>
		where TObjectConfiguration : NameTypeConfigurationElement
	{
		/// <summary>
		/// Gets the type of object that the factory will create.
		/// </summary>
		/// <param name="objectConfiguration">The configuration for the object to create.</param>
		/// <param name="configurationSource">An <see cref="IConfigurationSource"/> object.</param>
		/// <returns>The object type to create.</returns>
		/// <remarks>
		/// Returns the <see cref="Type"/> for the <typeparamref name="TObjectConfiguration"/>.
		/// </remarks>
		protected override Type GetObjectType(TObjectConfiguration objectConfiguration, IConfigurationSource configurationSource)
		{
			return objectConfiguration.Type;
		}
	}
}
